<?php
/**
 * The template for displaying all posts
 *
 * This is the template that displays all posts by default.
 * Please note that this is the WordPress construct of posts
 * and that other 'posts' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Brisbane-Building-Inspections
 */

get_header();
?>

<?php include 'custom-rows.php' ?>

<?php if( get_post_type() == 'services' ): ?>
    
    <?php
    if( have_rows('pricing') ): ?>
    <div class="container pb-5">
        <div class="row pb-lg-5 justify-content-center">
            <div class="col-12 pb-5">
                <hr class="black">
            </div>
            <div class="col-12 text-center pb-5">
                <h3>Pricing</h3>
            </div>
            <?php while ( have_rows('pricing') ) : the_row(); ?>
            <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                <?php 
                $image = get_sub_field('icon');
                if( !empty( $image ) ): ?>
                    <div class="mb-4"><img class="pricing-icon" src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr($image['alt']); ?>" /></div>
                <?php endif; ?>
                <?php if ( get_sub_field('title') ) : ?>
                    <p class="price-title"><?php echo get_sub_field('title'); ?></p>
                <?php endif; ?>
                <?php if ( get_sub_field('price') ) : ?>
                    <p class="price-number"><?php echo get_sub_field('price'); ?></p>
                <?php endif; ?>
                <?php if ( get_sub_field('details') ) : ?>
                    <p><?php echo get_sub_field('details'); ?></p>
                <?php endif; ?>
                
            </div>
            <?php endwhile; ?>
        </div>
    </div>
    <?php elseif(get_field('type_1_price') or get_field('type_2_price') or get_field('type_3_price') or get_field('type_4_price') or get_field('type_5_price')): ?>
    <div class="container pb-5">
        <div class="row pb-lg-5 justify-contnet-center">
            <div class="col-12 pb-5">
                <hr class="black">
            </div>
            <div class="col-12 text-center pb-5">
                <h3>Pricing</h3>
            </div>

            <?php if(get_field('type_1_price')): ?>
            <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-1.png" alt="unit icon"></div>
                <p class="price-title">Unit</p>
                <?php if ( get_field('type_1_price') ) : ?>
                    <p class="price-number"><?php echo get_field('type_1_price'); ?></p>
                <?php endif; ?>
                <?php if ( get_field('type_1_details') ) : ?>
                    <p><?php echo get_field('type_1_details'); ?></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if(get_field('type_2_price')): ?>
            <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-2.png" alt="unit icon"></div>
                <p class="price-title">Townhouse</p>
                <?php if ( get_field('type_2_price') ) : ?>
                    <p class="price-number"><?php echo get_field('type_2_price'); ?></p>
                <?php endif; ?>
                <?php if ( get_field('type_2_details') ) : ?>
                    <p><?php echo get_field('type_2_details'); ?></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if(get_field('type_3_price')): ?>
            <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-3.png" alt="unit icon"></div>
                <p class="price-title">Lowset Home</p>
                <?php if ( get_field('type_3_price') ) : ?>
                    <p class="price-number"><?php echo get_field('type_3_price'); ?></p>
                <?php endif; ?>
                <?php if ( get_field('type_3_details') ) : ?>
                    <p><?php echo get_field('type_3_details'); ?></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if(get_field('type_4_price')): ?>
            <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-4.png" alt="unit icon"></div>
                <p class="price-title">Highset Home</p>
                <?php if ( get_field('type_4_price') ) : ?>
                    <p class="price-number"><?php echo get_field('type_4_price'); ?></p>
                <?php endif; ?>
                <?php if ( get_field('type_4_details') ) : ?>
                    <p><?php echo get_field('type_4_details'); ?></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <?php if(get_field('type_5_price')): ?>
            <div class="col-6 col-md-4 col-lg text-center pb-4 pb-lg-0">
                <div class="mb-4"><img class="pricing-icon" src="<?php echo get_stylesheet_directory_uri(); ?>/images/pricing-5.png" alt="unit icon"></div>
                <p class="price-title">Large Home</p>
                <?php if ( get_field('type_5_price') ) : ?>
                    <p class="price-number"><?php echo get_field('type_5_price'); ?></p>
                <?php endif; ?>
                <?php if ( get_field('type_5_details') ) : ?>
                    <p><?php echo get_field('type_5_details'); ?></p>
                <?php endif; ?>
            </div>
            <?php endif; ?>

        </div>
    </div>
    <?php  endif; ?>

<div class="bg_texture left-black-30">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-4 bg_black py-5 pr-md-5">
                <div class="row py-lg-5 pr-lg-3">
                    <div class="col-12 pt-5 pt-lg-0 pb-lg-5 indent-text-white order-2 order-lg-1">
                        <?php if ( get_field('contact_form_row_text', 'cpt_services') ) : ?>
                            <?php echo get_field('contact_form_row_text', 'cpt_services'); ?>
                        <?php endif; ?>
                    </div>
                    <?php
                    $featured_posts = get_field('default_offer', 'cpt_services');
                    if( $featured_posts ): ?>
                    <div class="col-12 order-1 order-lg-2">
                    <?php foreach( $featured_posts as $post ): 
                        setup_postdata($post); ?>
                        <?php
                        $featured_post = get_field('default_offer', 'cpt_services');
                        if( $featured_post ): ?>
                            <p class="red-bg-sm"><?php the_field('type_of_offer'); ?></p>
                            <p class="mer-md"><?php the_field('intro_title'); ?></p>
                            <p class="red-bg-lg"><?php the_title(); ?></p>
                            <div class="d-flex align-items-center">
                                <div class="pr-3">
                                    <p class="small">ONLY</p>
                                    <p><span class="price">$<?php the_field('price_inc_gst'); ?></span> <span class="small">INC GST</span></p>
                                </div>
                                <div>
                                    <p class="white-circle d-flex align-items-center justify-content-center">Saves<br>$<?php the_field('saves'); ?></p>
                                </div>
                            </div>
                            <p><?php the_field('disclaimer'); ?></p>
                            <?php 
                            $link = get_field('link');
                            if( $link ): 
                                $link_url = $link['url'];
                                $link_title = $link['title'];
                                $link_target = $link['target'] ? $link['target'] : '_self';
                                ?>
                                <a class="btn btn-red" href="<?php echo esc_url( $link_url ); ?>" target="<?php echo esc_attr( $link_target ); ?>"><?php echo esc_html( $link_title ); ?></a>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; ?>
                    </div>
                        <?php 
                        wp_reset_postdata(); ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-12 col-lg-8 py-5 pl-lg-5">
                <div class="py-lg-5">
                    <?php if ( get_field('contact_form', 'cpt_services') ) : ?>
                        <?php echo get_field('contact_form', 'cpt_services'); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="py-lg-5">
    <div class="container py-5">
        <div class="row pb-5 justify-content-center">
            <div class="col-12 text-center">
                <h3><?php the_field('reviews_title', 'cpt_services'); ?></h3>
            </div>
            <div class="col-2">
                <hr class="black">
            </div>
        </div>
        
        <?php if (!isMobileDevice()): ?>
        <div class="row">
            <?php
            $featured_posts = get_field('reviews', 'cpt_services');
            if( $featured_posts ): ?>
                
                <?php foreach( $featured_posts as $post ): 
                    setup_postdata($post); ?>
                    <div class="col-12 col-md-6 col-lg pr-lg-4">
                        <div class="d-flex flex-column justify-content-between h-100 review-service relative">
                            <div class="review-excerpt">
                                <?php the_excerpt(); ?>
                            </div>
                            <p><?php the_title(); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <?php 
                wp_reset_postdata(); ?>
            <?php endif; ?>
        </div>
        <?php else: ?>
        <div class="owl-carousel full-mob px-2">
            <?php
            $featured_posts = get_field('reviews', 'cpt_services');
            if( $featured_posts ): ?>
                
                <?php foreach( $featured_posts as $post ): 
                    setup_postdata($post); ?>
                    <div class="item">
                        <div class="d-flex flex-column justify-content-between h-100 review-service relative">
                            <div class="review-excerpt">
                                <?php the_excerpt(); ?>
                            </div>
                            <p><?php the_title(); ?></p>
                        </div>
                    </div>
                <?php endforeach; ?>
                
                <?php 
                wp_reset_postdata(); ?>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    
        <div class="row pt-5 justify-content-center">
            <div class="col-2">
                <hr class="black">
            </div>
        </div>
    </div>
</div>

<?php endif; ?>

<?php
get_footer();
